-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles myself, the author, to unlimited free and unrestricted use, access, and distribution of any works related to the unauthorized user and/or distributor.

--]]

local THUnloadingStation = {}
THSprayTypes.UnloadingStation = THUnloadingStation
local THSellingStation = {}
THSprayTypes.SellingStation = THSellingStation
local THUnloadTrigger = {}
THSprayTypes.UnloadTrigger = THUnloadTrigger
local function initScript()
    THUtils.setFunctionHook("SellingStation", "load", false, false, nil, THSellingStation.gInj_load)
    THUtils.setFunctionHook("UnloadTrigger", "loadFillTypes", false, false, nil, THUnloadTrigger.gInj_loadFillTypes)
end
function THSellingStation.gInj_load(superFunc, parent, rootNode, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local fillTypeNames = wrappedXML:getString(xmlKey .. "#fillTypes")
            local fillTypeCategories = wrappedXML:getString(xmlKey .. "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THUtils.getIsDebugEnabled() then
                        THUtils.displayMsg("SellingStation: updated fill types: %s", newFillTypeNames)
                    end
                    wrappedXML:setString(xmlKey .. "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        wrappedXML:removeProperty(xmlKey .. "#fillTypeCategories")
                    end
                end
            end
            local stationFillTypes = {}
            local lastFillTypeXMLIndex = 0
            local defaultPriceScale, defaultGreatDemand, defaultPriceDrop = nil, nil, nil
            wrappedXML:iterate(xmlKey .. ".fillType", function(pFillTypeXMLIndex, pFillTypeKey)
                local fillTypeName = wrappedXML:getString(pFillTypeKey .. "#name")
                local priceScale = wrappedXML:getFloat(pFillTypeKey .. "#priceScale")
                local priceDrop = wrappedXML:getBool(pFillTypeKey .. "#disablePriceDrop")
                local greatDemand = wrappedXML:getBool(pFillTypeKey .. "#supportsGreatDemand")
                if fillTypeName ~= nil and fillTypeName ~= "" then
                    local thFillTypeData = g_thMapTypeManager:getFillType(fillTypeName)
                    local xtSprayTypeData = g_thSprayTypes:getExtendedSprayType(fillTypeName)
                    if thFillTypeData ~= nil and thFillTypeData ~= FillType.UNKNOWN
                        and (priceScale ~= nil or greatDemand ~= nil or priceDrop ~= nil)
                    then
                        if priceScale ~= nil then
                            if defaultPriceScale == nil or xtSprayTypeData ~= nil then
                                defaultPriceScale = priceScale
                            end
                        end
                        if priceDrop ~= nil then
                            if defaultPriceDrop == nil or xtSprayTypeData ~= nil then
                                defaultPriceDrop = priceDrop
                            end
                        end
                        if greatDemand ~= nil then
                            if defaultGreatDemand == nil or xtSprayTypeData ~= nil then
                                defaultGreatDemand = greatDemand
                            end
                        end
                        stationFillTypes[thFillTypeData.name] = {
                            priceScale = priceScale,
                            priceDrop = priceDrop,
                            greatDemand = greatDemand
                        }
                    end
                end
                lastFillTypeXMLIndex = math.max(lastFillTypeXMLIndex, pFillTypeXMLIndex)
            end)
            local _, newFillTypeList = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(stationFillTypes, nil, nil, true, true)
            if newFillTypeList ~= nil then
                for fillTypeId, newFillTypeData in pairs(newFillTypeList) do
                    local xtSprayTypeData = g_thSprayTypes:getExtendedSprayTypeByFillType(fillTypeId)
                    if xtSprayTypeData ~= nil and not xtSprayTypeData.isBaseType
                        and stationFillTypes[xtSprayTypeData.fillType.name] == nil
                    then
                        local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, lastFillTypeXMLIndex)
                        local priceScale = THUtils.getNoNil(newFillTypeData.priceScale, defaultPriceScale)
                        local greatDemand = THUtils.getNoNil(newFillTypeData.greatDemand, defaultGreatDemand)
                        local priceDrop = THUtils.getNoNil(newFillTypeData.priceDrop, defaultPriceDrop)
                        if priceScale ~= nil or greatDemand ~= nil or priceDrop ~= nil then
                            wrappedXML:setString(fillTypeKey .. "#name", xtSprayTypeData.fillType.name)
                            if priceScale ~= nil then
                                wrappedXML:setFloat(fillTypeKey .. "#priceScale", priceScale)
                            end
                            if greatDemand ~= nil then
                                wrappedXML:setBool(fillTypeKey .. "#supportsGreatDemand", greatDemand)
                            end
                            if priceDrop ~= nil then
                                wrappedXML:setBool(fillTypeKey .. "#disablePriceDrop", priceDrop)
                            end
                            if THUtils.getIsDebugEnabled() then
                                THUtils.displayMsg("SellingStation: added fillType %q", xtSprayTypeData.fillType.name)
                                THUtils.displayMsg("- priceScale: %s", priceScale)
                                THUtils.displayMsg("- supportsGreatDemand: %s", greatDemand)
                                THUtils.displayMsg("- disablePriceDrop: %s", priceDrop)
                            end
                            lastFillTypeXMLIndex += 1
                        end
                    end
                end
            end
        end
    end)
    return superFunc(parent, rootNode, xmlFile, xmlKey, ...)
end
function THUnloadTrigger.gInj_loadFillTypes(superFunc, parent, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if wrappedXML ~= nil then
            local fillTypeNames = wrappedXML:getString(xmlKey .. "#fillTypes")
            local fillTypeCategories = wrappedXML:getString(xmlKey .. "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = g_thSprayTypes:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THUtils.getIsDebugEnabled() then
                        THUtils.displayMsg("UnloadTrigger: updated fill types: %s", newFillTypeNames)
                    end
                    wrappedXML:setString(xmlKey .. "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        wrappedXML:removeProperty(xmlKey .. "#fillTypeCategories")
                    end
                end
            end
        end
    end)
    return superFunc(parent, xmlFile, xmlKey, ...)
end
THUtils.pcall(initScript)