
RVBRepair_Event = {}
local mt = Class(RVBRepair_Event, Event)
InitEventClass(RVBRepair_Event, "RVBRepair_Event")

function RVBRepair_Event.emptyNew()
	return Event.new(mt)
end
function RVBRepair_Event.new(vehicle, repair, message)
	local self = RVBRepair_Event.emptyNew()
	self.vehicle = vehicle
	self.repair = repair or {}
	self.message = message or {}
	return self
end
function RVBRepair_Event.readStream(self, streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.repair = {}
	self.repair.state        = streamReadInt16(streamId)
	self.repair.finishDay    = streamReadInt16(streamId)
	self.repair.finishHour   = streamReadInt16(streamId)
	self.repair.finishMinute = streamReadInt16(streamId)
	self.repair.cost         = streamReadFloat32(streamId)
	self.message = {}
	self.message.result = streamReadBool(streamId) or false
	self.message.cost   = streamReadFloat32(streamId) or 0
	self.message.text   = streamReadString(streamId) or ""
	self:run(connection)
end
function RVBRepair_Event.writeStream(self, streamId, _)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteInt16(streamId, self.repair.state)
	streamWriteInt16(streamId, self.repair.finishDay)
	streamWriteInt16(streamId, self.repair.finishHour)
	streamWriteInt16(streamId, self.repair.finishMinute)
	streamWriteFloat32(streamId, self.repair.cost)
	streamWriteBool(streamId, self.message.result or false)
	streamWriteFloat32(streamId, self.message.cost or 0)
	streamWriteString(streamId, self.message.text or "")
end
function RVBRepair_Event:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
		self.vehicle:SyncClientServer_RVBRepair(self.repair, self.message)
		if not connection:getIsServer() then
			--g_server:broadcastEvent(RVBRepair_Event.new(self.vehicle, self.repair, self.message), nil, nil, self.vehicle)
			g_server:broadcastEvent(self, false, connection, self.vehicle)
		end
	end
end
function RVBRepair_Event.sendEvent(vehicle, data, message, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RVBRepair_Event.new(vehicle, data, message), true, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(RVBRepair_Event.new(vehicle, data, message))
		end
	end
end